<?php session_start(); header('Content-Type: text/html; charset=utf-8'); ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="css/screen.css" />
</head>
<body>
<h1>Einführung in die Programmierung mit PHP</h1>
<h2>Sessions</h2>
<p>Sessions are used in PHP to provide a method to track a user throughout a website and pass data between pages about that user during their time on the site.</p>
<p>A unique ID is assigned to the user and the data is stored on the server itself, rather than on the user's computer such as with cookies.</p>
<p>The most common form of session usage is for commerce sites and the ability to have a shopping cart, user login and customized interfaces, and navigation history.</p>


<!-- ============ Ausgeben der Session ID ============== -->

<div class="example">
<p>Typischer Ablauf mit Session Variablen</p>

<span class="source">

// Session starten<br>
session_start();<br>
echo "Deine Session ID ist: " . session_id();<br><br><br>

// Speichern einer Sessionvariable im Array $_SESSION<br>
$_SESSION['color'] = 'blue';<br><br><br>


// Beenden der Session und Speichern der Variablen<br>//(wird am Ende der Seite automatisch gemacht)<br>
session_write_close();
</span><br><br>

<div class="box">
	<?php 
	
		//phpinfo();
	
		echo "Deine Session ID ist: " . session_id();
		$_SESSION['color'] = 'blue';

	?>
</div>
</div><br><br>


<!-- ============ Speicher der Fehlversuche ID ============== -->
<a name="counterrors" /><div class="example">
<p>Die Sessionvariablen werden am Server gespeichert und können jederzeit aufgerufen werden. Bei diesem Beispiel wird die Anzahl der Fehlversuche mitprotokolliert.<br><br>
<br>
<em>Richtiger Benutzer: Hans<br>
Richtiges Passwort: Hinterseer<br></em>
</p>

<div class="box">
	<form action="<?php echo basename(__file__)."#counterrors";?>" method="post">
	<table>
		<tr>
			<td>Benutzername</td>
			<td><input type="text" name="username" value=""></td>
			<td>
				<?php 
				
					$user = "";
					$passwort = "";
									
					// Erstellen der Funktion
					if ( !isset ( $_SESSION["faults"] ) )
					{
						$_SESSION["faults"] = 0;
					}
					
					// Alle POST Variablen werden in einem Array  $_POST gespeichert
					if ( isset($_POST[ "username" ] ))
						$user= $_POST[ "username" ];

						 
					if ( isset($_POST[ "password" ] ))
						$password = $_POST [ "password" ];

						
					if ( $user != "Hans" && $user != "" )
					{
						echo "Benutzername nicht bekannt.";
					}		
				?>
			</td>
		</tr>
		<tr>
			<td>Passwort</td>
			<td><input type="password" name="password"></td>
			<td>
				<?php 
					if ( $user == "Hans" && $password != "Hinterseer" && $password != "" )
					{
						echo "Falsches Passwort";
					}
				
				?>
			</td>
		</tr></table>
	<br>
	<input type="submit" value="Login">
				<?php
				

	

	if ( $user == "Hans" && $password == "Hinterseer" )
	{
		echo "Benutzer und Passwort richtig";
		$_SESSION["faults"] = 0;
	}
	else
	{	
		$_SESSION["faults"] = $_SESSION["faults"] + 1;

		echo "Anzahl der Fehlversuche: ".$_SESSION["faults"];
	}
	
	
	session_write_close();
				?>
	
	</form>
</div>

</div>
<br><br>



<div class="exercise">
<p>Erstelle eine Seite mit einem Login-Formular und eine Seite mit Inhalten.</p>
	<ul>
		<li>Zeige auf der Seite mit den Inhalten bestimmte Informationen nur an, wenn der Benutzer als Administrator eingeloggt ist. Übergib dabei die Information, ob der Benutzer eingeloggt ist oder nicht mit Hilfe eine Session-Variable</li>
		<li>Logge mit, wie viele Versuche der Benutzer gebraucht hat, um sich richtig einzuloggen.</li>
		<li>Füge die Möglichkeit hinzu sich auszuloggen</li>
	</ul>
	
<p>Zuatz: Erstellen in der Datenbank eine Tabelle mit Benutzern mit unterschiedlichen Rechten:</p>
	<ul>
		<li>Rechte: Administrator, Redakteur, Gast</li>
		<li>Gib abhängig von den Rechten unterschiedliche Informationen aus.</li>
		<li>Sperre das Login-Formular für 30 Sekunden, wenn der Benutzer mehr als 3 Fehlversuche hat.<br><br><span class="source">
			$curTime = getdate();<br>
			$curTime = $info['hours'];<br>
			$curTime = $info['minutes'];<br>
			$sec = $curTime['seconds'];
		</span>
		<br><br>

<div class="box">
	<?php 
			$curTime = getdate();
			$hour = $curTime['hours'];
			$minute = $curTime['minutes'];
			$sec = $curTime['seconds'];
			echo "Aktuelle Serverzeit: ".$hour.":".$minute.".".$sec;
	?>
</div>
		
		
		
		</li>
	</ul>
	</div>
	
	<div class="menu">
<?php include 'menu.php'; ?>
</div>
	
</body>
</html>