﻿<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="css/screen.css" />
</head>
<body>
<h1>Einführung in die Programmierung mit PHP</h1>
<h2>Formulare</h2>
<p>Es gibt 2 Methoden, wie man Formulardaten an den Server übermitteln kann:</p>
<!-- ============ GET ============== -->

<h3>Formularübermittlung per GET</h3>
<span class="source">&lt;form action="http://localhost/willkommen.php" method="get"></span><br><br>
	<p><b>Übermittlung der Daten</b><br>GET hängt die Formulardaten an die URL an, bevor die Anfrage an den Server geschickt wird, z.B.:<br><br>
<span class="source">http://localhost/willkommen.php?nickname=Christian</span>.<br><br>
Angeben wird das im Formular mit dem Parameter <span class="source">method</span>:<br>

	</p>
<p><b>Anhängen an die URL</b><br>
Hinter dem <span class="source">?</span> am Ende der URL wird der Variablenname angegeben. Werden mehrere Variable verwendet, so sind diese durch ein <span class="source">&</span> getrennt, z.B:<br><br>
<span class="source">http://localhost/willkommen.php?nickname=Christian&user_id=123</span></p>

<p><b>Das Array $_GET</b><br>
PHP erzeugt automatisch ein Array, $_GET, das alle Werte enthält, die in der URL übergeben
werden. Über den Namen kann man auf den Wert zugreifen (assoziatives Array):<br><br>
<span class="source">$nick = $_GET[ "nickname" ];<br>echo "Hallo ".$nick."!<br><br></span></p>

<a name="formget"/>
<div class="example">
<p>Es wird die Variable und der Wert an die URL angehängt (siehe URL).<br>
	Nachteil: Jeder sieht die Variablen und deren Inhalte in der URL und kann diese auch anpassen.
</p>
<div class="box">
	<?php 
		// Alle GET Variabel werden in einem Array  $_GET gespeichert
		$nick = $_GET[ "nickname" ]; 
		
		if ( $nick )
		{
			echo "Hallo ".$nick."!<br><br>";
		}		
	?>
	<form action="<?php echo basename(__file__)."#formget";?>" method="get">
	Nickname<br><input type="text" name="nickname" value="<?php echo $nick;?>">
	<br>
	<input type="submit" value="Nickname an die URL anhängen!">
	</form>
</div>


</div>



<!-- ============ POST ============== -->
<h3>Formularübermittlung per POST</h3>
<span class="source">&lt;form action="http://localhost/willkommen.php" method="post"></span><br><br>

	<p><b>Beispiel: Benutzername und Passwort</b><br>
	Passwörter dürfen nicht in der URL für jeden sichtbar sein.<br>
	Deshalb werden diese Formulardaten mit POST übermittelt.
	</p>

	<p><b>Das Array $_POST</b><br>
	PHP erzeugt automatisch ein Array, $_POST, das alle Werte enthält, die per POST
	werden. Über den Namen kann man auf den Wert zugreifen (assoziatives Array):<br><br>
	<span class="source">$nick = $_POST[ "user" ];<br>echo "Hallo ".$user."!<br><br></span></p>

<a name="formpost"/>
<div class="example">
<p>Die Variablen werden "unsichtbar" übergeben. In PHP kann man auf die Werte reagieren, ohne dass jeder sieht, welche Werte und Variablen verwendet werden.<br><br>
<br>
<em>Richtiger Benutzer: Hans<br>
Richtiges Passwort: Hinterseer<br></em>
</p>
<div class="box">
	<form action="<?php echo basename(__file__)."#formpost";?>" method="post">
	<table>
		<tr>
			<td>Benutzername</td>
			<td><input type="text" name="username" value="<?php echo $user;?>"></td>
			<td>
				<?php 
					// Alle POST Variablen werden in einem Array  $_POST gespeichert
					$user= $_POST[ "username" ]; 
					$password = $_POST [ "password" ];
					
					if ( $user != "Hans" && $user != "" )
					{
						echo "Benutzername nicht bekannt.";
					}		
				?>
			</td>
		</tr>
		<tr>
			<td>Passwort</td>
			<td><input type="password" name="password"></td>
			<td>
				<?php 
					if ( $user == "Hans" && $password != "Hinterseer" && $password != "" )
					{
						echo "Falsches Passwort";
					}
				?>
			</td>
		</tr></table>
	<br>
	<input type="submit" value="Passwort überprüfen!">
				<?php 

	if ( $user == "Hans" && $password == "Hinterseer" )
	{
		echo "Benutzer und Passwort richtig";
	}
				?>
	
	</form>
</div>

</div>
<p></p>

<div class="exercise">
<p>Erstelle ein Kontaktformular, das die einzelnen Felder auf die Syntax hin überprüft:</p>
	<ul>
	<li>Vorname – Mindestens 3 Buchstaben</li>
	<li>Nachname – Mindestens 3 Buchstaben</li>
	<li>E-Mail Adresse
		<ul>
			<li>Mindestens ein Buchstabe vor dem @</li>
			<li>Genau ein @ enthalten</li>
			<li>Mindestens ein . nach dem @</li>
			<li>Mindestens ein Buchstabe vor jedem .</li>
			<li>Mindestens ein Buchstabe nach jedem .</li>
		</ul>
	</li>
	<li>Telefonnummer – Nur Zahlen</li>
	</ul>
	Bereits richtige Eingaben sollen bei der Formularübermittlung erhalten bleiben.<br>
	Falsche Eingaben sollen gekennzeichnet werden.
	<br><br>
	<b>Wichtige Stringfunktionen:</b><br><br>
<span class="source">int strlen ( string $string )</span><br><br>
<span class="source">int strcmp( string $string1, string $string2)</span><br><br>
<span class="source">int strpos ( string $haystack, mixed $needle [, int $offset] )</span><br>
Mit strpos() kann man innerhalb einer Zeichenkette (haystack) das erste Vorkommen eines
Zeichens (needle) oder einer Zeichenkette (needle) suchen. Als Rückgabewert der Funktion erhält
man die Position des Suchtreffers entspricht, sonst wird false zurückgegeben. Mit dem optionalen
Parameter offset bestimmt man die Startposition, ab der gesucht werden soll.<br><br>
<span class="source">string strstr ( string $haystack, string $needle )</span><br>
Mit strstr() kann man innerhalb einer Zeichenkette (haystack) das erste Vorkommen eines
Strings (needle) suchen. Im Erfolgsfall gibt diese Funktion die Zeichenkette ab der Position des
Suchtreffers bis zum Ende zurück, sonst false.<br><br>
<span class="source">$woerter = explode( " ", "Angie Brad");</span><br>
Zerlegt einen String mit dem angegebenen Trennzeichen in ein Array mit Teilstrings.<br><br>
<span class="source">$wort = implode( " ", "$woerter");</span><br>
Macht aus einem Array mit Teilstrings einen String.<br><br>
<span class="source">$wort = str_replace( "+", "*", "A+B+C");</span><br>
Ersetzt im String alle + durch *.<br><br>
<?php include '03_formulare_aufgabe.php'; ?>

<p>Formatiere das Formular mittels CSS
</p>
</div>

<div class="menu">
<?php include 'menu.php'; ?>
</div>

</body>
</html>