﻿<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="css/screen.css" />
</head>
<body>
<h1>Einführung in die Programmierung mit PHP</h1>
<h2>Arrays</h2>
<p>Es gibt 2 Arten von Arrays:
	<ul>
	<li>Indexierte Arrays (so wie z.B. in C)</li>
	<li>Assoziative Arrays (wie für <span class="source">$_GET</span> und <span class="source">$_POST</span> verwendet)</li></ul>
</p>
<!-- ============ Indexierte Arrays ============== -->

<h3>Indexierte Arrays</h3>
<span class="source">

$highscore = array (200, 198, 210, 788);<br>
$highscoreNames = array ("Hans", "Franz", "Helge", "Mimi");


</span><br><br>
<div class="example">
<p>Ausgeben des Arrays mit <span class="source">$foreach</span>:<br><br>

<span class="source">

		foreach ( $highscore as $score )<br>
		{<br>
			&nbsp;&nbsp;&nbsp;&nbsp;echo $score."&lt;br&gt;";<br>
		}

</span><br></p>
<div class="box">
	<?php 
		// Anlegen der Arrays
		$highscore = array (200, 198, 210, 788);
		$highscoreNames = array ("Hans", "Franz", "Helge", "Mimi");
		
		foreach ( $highscore as $score )
		{
			echo $score."<br>";
		}		
	?>
</div>
<p>Mit dem Befehl <span class="source">sort ($highscore)</span>(aufsteigend) oder <span class="source">rsort ($highscore)</span>(absteigend) können Arrays einfach sortiert werden:<br><br>

<span class="source">

		rsort ($highscore );<br>
		for ($i = 0; $i < count($highscore); $i++ )<br>
		{<br>
			&nbsp;&nbsp;&nbsp;&nbsp;echo ($i+1)." ".$highscoreNames[$i]." ".$highscore[$i]."&lt;br&gt";<br>
		}


</span>
</p>
<div class="box">	<?php 

		rsort ($highscore );
		for ($i = 0; $i < count($highscore); $i++ )
		{
			echo ($i+1)." ".$highscoreNames[$i]." ".$highscore[$i]."<br>";
		}		
	?>
</div>
</div>



<!-- ============ Assoziative Arrays ============== -->
<h3>Assoziative Arrays</h3>
<span class="source">

$teams = array ('San Francisco'=>'49ers', 'Oakland'=>'Raiders', 'Miami'=>'Dolphins');<br>

</span><br><br>
<div class="example">
<p>Ausgeben des Arrays mit <span class="source">$foreach</span>:<br><br>

<span class="source">

		foreach ( $teams as $name => $nickname  )<br>
		{<br>
			&nbsp;&nbsp;&nbsp;&nbsp;echo "&lt;b&gt;".$name."&lt;/b&gt; ".$nickname."&lt;br&gt;";<br>
		}

</span><br></p>
<div class="box">
	<?php 
		// Anlegen der Arrays
		$teams = array ('San Francisco'=>'49ers', 'Oakland'=>'Raiders', 'Miami'=>'Dolphins');
				
		foreach ( $teams as $name => $nickname )
		{
			echo "<b>".$name."</b> ".$nickname."<br>";
		}		
	?>
</div>
<p>Über den Schlüssel kann auf den Wert zugegriffen werden:<br><br>

<span class="source">

		echo $teams['San Francisco'];<br>
</span>
</p>
<div class="box">	<?php 

		echo $teams['San Francisco'];
	?>
</div>
</div>

<div class="menu">
<?php include 'menu.php'; ?>
</div>

</body>
</html>