﻿<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="css/screen.css" />
</head>
<body>
<h1>Einführung in die Programmierung mit PHP</h1>
<h2>Erste Schritte</h2>

<!-- ============ Grundgerüst ============== -->

<h3>Grundgerüst einer PHP Datei</h3>
<p>Eine Datei erstellen, mit der Extension<span class="source">.php</span><br><br>

Eine PHP-Datei kann aus verschiedenen Bereichen bestehen:
<br><br>
Alles, was zwischen den Tags <span class="source">&lt;?php</span> und <span class="source">?&gt</span>  steht, ist PHP-Quelltext, der vom Server interpretiert wird. Dieser PHP-Quelltext scheint nicht im HTML-Quelltext auf, der vom Server generiert und and den Client geschickt wird.
<br><br>
Alles, das ausserhalb dieser Tags steht wird in den generierten HTML-Quelltext übernommen. In einer PHP-Datei können sich beliebig viele HTML- und PHP-Bereiche befinden.<br><br>


<span class="source">
&lt;!-- helloworld.php --&gt;<br>
&lt;html&gt;<br>
&nbsp;&nbsp;&nbsp;&lt;body&gt;<br>
&nbsp;&nbsp;&nbsp;&lt;?php<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;echo ("Hello World");<br>
&nbsp;&nbsp;&nbsp;?&gt;<br>
&nbsp;&nbsp;&nbsp;&lt;/body&gt;<br>
&lt;/html&gt;<br>
</span></p>




<!-- ============ Kommentare ============== -->

<h3>Kommentare</h3>
<p>Kommentare werden so wie in C, Java oder Javascript gesetzt:<br><br>
<span class="source">
		//&nbsp;Kommentar über eine Zeile oder<br>
		/*&nbsp;Ein längerer <br>&nbsp;&nbsp;&nbsp;Kommentar, der sich über<br>&nbsp;&nbsp;&nbsp;mehrere Zeilen erstreckt*/<br>
</span>
</p>



<!-- ============ Variablen ============== -->

<h3>Variablen</h3>
<p>
Variablen beginnen alle mit einem <span class="source">$</span>.<br>
Variablen haben in PHP keinen expliziten Datentyp und werden automatisch angelegt, sobald es einen Variablennamen noch nicht gibt.<br><br>
<span class="source">
	$myString = "Hallo 4BHELS";<br>
	$myNumber = 44;<br><br>
	$myArray = array();<br>
	$myArray[] = "Bob";<br>
	$myArray[] = "Peter";<br>
	$myArray[] = "Lisa";<br>
</span>
</p>



<!-- ============ Ausgabe ============== -->

<h3>Ausgabe</h3>
<p>Neben der Ausgabe von HTML-Quelltext durch Unterbrechen des PHP-Quelltexts, kann die Ausgabe innerhalb des PHP-Quelltextes mit <span class="source">echo</span> erfolgen:<br><br>
<span class="source">
	
		// Ausgaben <br>
		// - Klammer ist nicht unbedingt notwendig <br>
		// - ext zwischen '' oder ""<br>
		echo ("Hello");<br><br>

		echo ("Hello");<br>
		echo ' World';<br><br><br>
</span>			
		Strings werden mit einem . verknüpft:<br><br>
		<span class="source">
		echo "&lt;br&gt;" . $myNext . $myNumber;<br>
</span></p>
<div class="example">

<p>Einfache Ausgaben mit <span class="source">echo</span><br><br>

<span class="source">
		echo ("Hello");<br>
		echo ' World';
</span><br></p>
<div class="box">
	<?php 
		echo ("Hello");
		echo ' World';	
	?>
</div>

<p>Verknüpfen von Strings<br><br>

<span class="source">
	$myString = "Hallo 4BHELS";<br>
	$myNumber = 44;<br><br>
	echo $myString . $myNumber;<br>
</span><br></p>
<div class="box">
	<?php 
		
	// Variablen haben keinen Datentypen und Variablenname beginnen immer mit $
	$myString = "Hallo 4BHELS";
	$myNumber = 44;
	
	echo $myString . $myNumber;
	?>
</div>

</div>



<!-- ============ Berechnungen ============== -->
<h3>Berechnungen</h3>
<p>Neben der Ausgabe von HTML-Quelltext durch Unterbrechen des PHP-Quelltexts, kann die Ausgabe innerhalb des PHP-Quelltextes mit <span class="source">echo</span> erfolgen:<br><br>

	
Berechnungen funktionieren wie in C: <br> <br>
<span class="source">
	$myResult = $myNumber * 2;
</span></p>

<div class="example">

<p>Einfache Berechnung mit Ausgabe:<br><br>

<span class="source">
echo "&lt;br&gt;Berechnungen: " . $myNumber." * 2 = " . $myNumber * 2;
</span><br></p>
<div class="box">
	<?php 
		echo "<br>Berechnungen: " . $myNumber." * 2 = " . $myNumber * 2;
	?>
</div>

</div>


<!-- ============ Kontrollstrukturen und Schleifen ============== -->

<h3>Kontrollstrukturen und Schleifen</h3>
<p>Kontrollstrukturen wie <span class="source">if</span>, <span class="source">switch</span>, <span class="source">while</span>, <span class="source">for</span>, <span class="source">...</span>, können genau so wie in der Programmiersprache <span class="source">C</span> verwendet werden.<br>
Die Vergleichsoperatoren <span class="source">== != &lt; &lt;= =&gt; &gt; </span> und die logischen Operatoren <span class="source">&& ||</span></span> sind dieselben wie in <span class="source">C</span>.
</p>
<div class="exercise">
<p>Gib die Zahlen von 1 bis 20 untereinander aus und gib neben der jeweiligen Zahl an, ob sie gerade oder ungerade ist:</p>
<div class="box">
<?php
	// Kontrollstrukturen und Schleifen funktionieren so wie in C
	

	for ( $i = 1; $i < 20; $i ++ )
	{
		echo "Die Zahl " . $i ." ist ";
		if ( $i % 2 != 0 )
		{	
			echo "un";
		}	
		echo "gerade<br>";
	}
?>
</div>
</div>
<h3>PHP und HTML kombinieren</h3>
<div class="exercise">
<p>Schreibe eine Multiplikationstabelle, die die Zahlen von 1 bis 10 mit den Zahlen von 1 bis 15 miteinander multipliziert:</p>
<div class="box">
<table>
<?php 
	$rows = 10;
	$columns = 15;
	
	echo "<th></th>";
	for ( $i = 1; $i <= $columns; $i ++ )
	{
		echo "<th>".$i."</th>";
	}
	
	for ( $i = 1; $i <= $rows; $i ++ )
	{
	
?>
			<tr>
			<th><?php echo $i; ?></th>
<?php
			for ( $j = 1; $j <= $columns; $j ++ )
			{
?>				
			<td><?php echo $i * $j ?></td>	
<?php		
			}
?>		
			</tr>		
<?		
	}
?>
</table></div>
<p>Style die Tabelle mit Hilfe von CSS.</p>

<div class="box">
<table class="table_styled">
<?php 
	$rows = 10;
	$columns = 20;
	
	echo "<th></th>";
	for ( $i = 1; $i <= $columns; $i ++ )
	{
		echo "<th>".$i."</th>";
	}
	
	for ( $i = 1; $i <= $rows; $i ++ )
	{
	
?>
			<tr>
			<th><?php echo $i; ?></th>
<?php
			for ( $j = 1; $j <= $columns; $j ++ )
			{
?>				
			<td><?php echo $i * $j ?></td>	
<?php		
			}
?>		
			</tr>		
<?		
	}
?>
</table></div>
</div>

</div>


</table>

<div class="menu">
<?php include 'menu.php'; ?>
</div>

</body>
</html>